<?php
declare(strict_types=1);

require_once __DIR__ . '/_bootstrap.php';
require_once __DIR__ . '/_layout.php';

if (is_admin_logged_in()) {
    header('Location: users.php');
    exit();
}

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_require();

    $username = trim((string)($_POST['username'] ?? ''));
    $password = (string)($_POST['password'] ?? '');

    if ($username === '' || $password === '') {
        $error = 'Kullanıcı adı ve şifre gerekli.';
    } else {
        try {
            $stmt = db()->prepare("SELECT id, username, password, role, is_active FROM users WHERE username = :u LIMIT 1");
            $stmt->execute([':u' => $username]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            $ok = is_array($user)
                && ($user['is_active'] ?? 0) == 1
                && ($user['role'] ?? '') === 'admin'
                && password_verify($password, (string)($user['password'] ?? ''));

            if (!$ok) {
                $error = 'Giriş başarısız.';
            } else {
                session_regenerate_id(true);
                $_SESSION['admin_user_id'] = (int)$user['id'];
                $_SESSION['admin_username'] = (string)$user['username'];
                flash_set('ok', 'Giriş başarılı');
                header('Location: users.php');
                exit();
            }
        } catch (Throwable $e) {
            $error = 'Sunucu hatası.';
        }
    }
}

ob_start();
?>
<div class="card" style="max-width:520px;margin:24px auto">
    <h2>Admin Giriş</h2>
    <div class="body">
        <?php if ($error): ?>
            <div class="flash bad"><?php echo e($error); ?></div>
        <?php endif; ?>

        <form method="post" autocomplete="on">
            <input type="hidden" name="csrf" value="<?php echo e(csrf_token()); ?>">
            <label>Kullanıcı adı</label>
            <input name="username" value="<?php echo e((string)($_POST['username'] ?? '')); ?>" autocomplete="username" required>
            <label>Şifre</label>
            <input name="password" type="password" autocomplete="current-password" required>
            <div style="margin-top:14px" class="row">
                <button class="btn" type="submit">GİRİŞ</button>
                <span class="muted">Sadece admin kullanıcıları girebilir.</span>
            </div>
        </form>
    </div>
</div>
<?php
$html = ob_get_clean();
render_layout('Admin Giriş', $html);

