<?php
declare(strict_types=1);

require_once __DIR__ . '/_bootstrap.php';

function render_layout(string $title, string $contentHtml): void
{
    $flash = flash_get();
    ?>
    <!doctype html>
    <html lang="tr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo e($title); ?></title>
        <style>
            :root{
                --brand:#E00000;
                --bg:#F5F7FB;
                --card:#FFFFFF;
                --ink:#111827;
                --muted:#6B7280;
                --line:#E5E7EB;
                --ok:#16A34A;
                --bad:#DC2626;
                --warn:#F59E0B;
                --shadow:0 10px 24px rgba(16,24,40,.08);
                --radius:14px;
            }
            *{box-sizing:border-box}
            body{margin:0;font-family:ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;background:var(--bg);color:var(--ink)}
            a{color:inherit}
            .top{background:rgba(255,255,255,.92);backdrop-filter:blur(10px);border-bottom:1px solid var(--line)}
            .top::before{content:"";display:block;height:4px;background:linear-gradient(90deg,var(--brand),#B80000)}
            .wrap{max-width:1080px;margin:0 auto;padding:14px 16px}
            .row{display:flex;align-items:center;justify-content:space-between;gap:12px}
            .brand{display:flex;align-items:center;gap:10px;font-weight:800}
            .pill{display:inline-flex;align-items:center;gap:8px;padding:6px 10px;border:1px solid var(--line);border-radius:999px;background:#fff}
            .muted{color:var(--muted);font-size:13px}
            .grid{display:grid;grid-template-columns:1.2fr .8fr;gap:16px}
            @media (max-width: 900px){.grid{grid-template-columns:1fr}}
            .card{background:var(--card);border:1px solid var(--line);border-radius:var(--radius);box-shadow:var(--shadow)}
            .card h2{margin:0;padding:14px 16px;border-bottom:1px solid var(--line);font-size:16px}
            .card .body{padding:14px 16px}
            .flash{padding:10px 12px;border-radius:12px;border:1px solid var(--line);background:#fff;margin-bottom:12px}
            .flash.ok{border-color:rgba(22,163,74,.25);background:rgba(22,163,74,.06)}
            .flash.bad{border-color:rgba(220,38,38,.25);background:rgba(220,38,38,.06)}
            .flash.warn{border-color:rgba(245,158,11,.25);background:rgba(245,158,11,.08)}
            table{width:100%;border-collapse:collapse}
            th,td{padding:10px 8px;border-bottom:1px solid var(--line);text-align:left;font-size:14px}
            th{color:var(--muted);font-weight:700;font-size:12px;letter-spacing:.02em;text-transform:uppercase}
            .tag{display:inline-flex;align-items:center;padding:4px 8px;border-radius:999px;border:1px solid var(--line);font-size:12px}
            .tag.ok{color:var(--ok);border-color:rgba(22,163,74,.25);background:rgba(22,163,74,.06)}
            .tag.bad{color:var(--bad);border-color:rgba(220,38,38,.25);background:rgba(220,38,38,.06)}
            .tag.warn{color:var(--warn);border-color:rgba(245,158,11,.25);background:rgba(245,158,11,.08)}
            .actions{display:flex;gap:8px;flex-wrap:wrap}
            input,select{width:100%;padding:10px 12px;border:1px solid var(--line);border-radius:12px;font-size:14px;outline:none;background:#fff}
            input:focus,select:focus{border-color:rgba(224,0,0,.45);box-shadow:0 0 0 4px rgba(224,0,0,.12)}
            label{display:block;font-size:12px;color:var(--muted);margin:10px 0 6px}
            button{padding:10px 12px;border-radius:12px;border:1px solid var(--line);background:#fff;cursor:pointer;font-weight:700}
            .btn{background:var(--brand);color:#fff;border-color:transparent}
            .btn.secondary{background:#111827}
            .btn.danger{background:var(--bad)}
            .btn:disabled{opacity:.6;cursor:not-allowed}
            .split{display:grid;grid-template-columns:1fr 1fr;gap:12px}
            @media (max-width: 520px){.split{grid-template-columns:1fr}}
        </style>
    </head>
    <body>
    <div class="top">
        <div class="wrap row">
            <div class="brand">
                <span style="width:10px;height:10px;border-radius:3px;background:var(--brand);display:inline-block"></span>
                ABALI Panel
            </div>
            <div class="row">
                <?php if (is_admin_logged_in()): ?>
                    <span class="pill muted">Giriş: <?php echo e(current_admin_username()); ?></span>
                    <a class="pill" href="users.php">Kullanıcılar</a>
                    <a class="pill" href="logout.php">Çıkış</a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="wrap">
        <?php if ($flash): ?>
            <?php
            $klass = 'flash';
            if (($flash['type'] ?? '') === 'ok') $klass .= ' ok';
            if (($flash['type'] ?? '') === 'bad') $klass .= ' bad';
            if (($flash['type'] ?? '') === 'warn') $klass .= ' warn';
            ?>
            <div class="<?php echo e($klass); ?>">
                <?php echo e((string)($flash['message'] ?? '')); ?>
            </div>
        <?php endif; ?>

        <?php echo $contentHtml; ?>
        <div class="muted" style="margin-top:16px">© ABALI — basit kullanıcı yönetimi</div>
    </div>
    </body>
    </html>
    <?php
}

