<?php
// Servis Kaydı Güncelleme (Admin)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Geçersiz token']);
    exit();
}

// Admin kontrolü
if ($decoded['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Yetkisiz işlem']);
    exit();
}

$data = json_decode(file_get_contents("php://input"));

if (empty($data->service_id)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Servis ID gerekli'
    ]);
    exit();
}

try {
    $db->beginTransaction();

    // Servis kaydı kontrolü
    $check_query = "SELECT id FROM service_records WHERE id = :id LIMIT 1";
    $check_stmt = $db->prepare($check_query);
    $check_stmt->bindParam(':id', $data->service_id);
    $check_stmt->execute();

    if ($check_stmt->rowCount() == 0) {
        throw new Exception('Servis kaydı bulunamadı');
    }

    // Güncelleme alanları
    $updates = [];
    $params = [':id' => $data->service_id];

    if (isset($data->service_date)) {
        $updates[] = "service_date = :service_date";
        $params[':service_date'] = $data->service_date;
    }

    if (isset($data->description)) {
        $updates[] = "description = :description";
        $params[':description'] = $data->description;
    }

    if (isset($data->status)) {
        $updates[] = "status = :status";
        $params[':status'] = $data->status;
    }

    if (empty($updates)) {
        throw new Exception('Güncellenecek alan bulunamadı');
    }

    $update_query = "UPDATE service_records SET " . implode(', ', $updates) . " WHERE id = :id";
    $update_stmt = $db->prepare($update_query);
    $update_stmt->execute($params);

    $db->commit();

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'Servis kaydı güncellendi'
    ]);

} catch (Exception $e) {
    $db->rollBack();
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
