<?php
// Bekleyen Servisleri Listele (Sadece Admin)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded || $decoded['role'] != 'admin') {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Yetkiniz yok']);
    exit();
}

// Bekleyen servisleri getir
$query = "SELECT
            sr.id,
            sr.service_date,
            sr.description,
            sr.total_amount,
            sr.status,
            sr.created_at,
            v.plate,
            v.brand,
            v.model,
            c.name as customer_name,
            c.phone as customer_phone,
            u.full_name as technician_name
          FROM service_records sr
          JOIN vehicles v ON sr.vehicle_id = v.id
          JOIN customers c ON v.customer_id = c.id
          LEFT JOIN users u ON sr.technician_id = u.id
          WHERE sr.status = 'pending'
          ORDER BY sr.created_at DESC";

try {
    $stmt = $db->prepare($query);
    $stmt->execute();
    $services = $stmt->fetchAll();
} catch (Throwable $e) {
    error_log('pending.php error: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Sunucu hatası',
    ]);
    exit();
}

http_response_code(200);
echo json_encode([
    'success' => true,
    'services' => $services,
    'count' => count($services)
]);
