<?php
// Araç için servis geçmişi (Teknisyen ve Admin)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Geçersiz token']);
    exit();
}

$vehicle_id = isset($_GET['vehicle_id']) ? (int)$_GET['vehicle_id'] : 0;
if ($vehicle_id <= 0) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Araç ID gerekli']);
    exit();
}

try {
    $query = "SELECT
                sr.id,
                sr.vehicle_id,
                sr.technician_id,
                sr.service_date,
                sr.km_reading,
                sr.description,
                sr.total_amount,
                sr.status,
                sr.created_at,
                sr.updated_at,
                u.full_name as technician_name
              FROM service_records sr
              LEFT JOIN users u ON u.id = sr.technician_id
              WHERE sr.vehicle_id = :vehicle_id
              ORDER BY sr.service_date DESC, sr.created_at DESC, sr.id DESC";

    $stmt = $db->prepare($query);
    $stmt->bindParam(':vehicle_id', $vehicle_id, PDO::PARAM_INT);
    $stmt->execute();

    $services = $stmt->fetchAll(PDO::FETCH_ASSOC);

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'data' => $services,
        'count' => count($services)
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'İşlem sırasında hata oluştu'
    ]);
}

