<?php
// Servis Kaydı Detay Getirme

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

$service_id = isset($_GET['id']) ? $_GET['id'] : null;
$show_prices = isset($_GET['show_prices']) ? $_GET['show_prices'] : '0';

// Token kontrolü (fiyat gösterimi için)
if ($show_prices == '1') {
    $token = JWT::getBearerToken();
    if (!$token) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
        exit();
    }

    $decoded = JWT::decode($token);
    if (!$decoded) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Geçersiz token']);
        exit();
    }
}

if (empty($service_id)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Servis ID gerekli'
    ]);
    exit();
}

// Servis kaydı getir
$query = "SELECT sr.*, u.full_name as technician_name, v.plate, v.brand, v.model,
          c.name as customer_name, c.phone
          FROM service_records sr
          LEFT JOIN users u ON u.id = sr.technician_id
          LEFT JOIN vehicles v ON v.id = sr.vehicle_id
          LEFT JOIN customers c ON c.id = v.customer_id
          WHERE sr.id = :id
          LIMIT 1";

$stmt = $db->prepare($query);
$stmt->bindParam(':id', $service_id);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $service = $stmt->fetch();

    // Servis itemları getir
    $items_query = "SELECT * FROM service_items WHERE service_record_id = :service_id ORDER BY created_at ASC";
    $items_stmt = $db->prepare($items_query);
    $items_stmt->bindParam(':service_id', $service_id);
    $items_stmt->execute();
    $items = $items_stmt->fetchAll();

    // Fiyat gösterimi kontrolü (müşteri görmeyecek)
    if ($show_prices == '0') {
        // Fiyatları kaldır
        unset($service['total_amount']);
        foreach ($items as &$item) {
            unset($item['unit_price']);
            unset($item['total_price']);
        }
    }

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'service' => $service,
        'items' => $items
    ]);
} else {
    http_response_code(404);
    echo json_encode([
        'success' => false,
        'message' => 'Servis kaydı bulunamadı'
    ]);
}
