<?php
// Servis İşlemi Silme (Admin ve Teknisyen)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Geçersiz token']);
    exit();
}

$data = json_decode(file_get_contents("php://input"));

if (empty($data->item_id)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'İşlem ID gerekli'
    ]);
    exit();
}

try {
    $db->beginTransaction();

    // Item kontrolü ve service_record_id al
    $item_query = "SELECT service_record_id FROM service_items WHERE id = :id LIMIT 1";
    $item_stmt = $db->prepare($item_query);
    $item_stmt->bindParam(':id', $data->item_id);
    $item_stmt->execute();

    if ($item_stmt->rowCount() == 0) {
        throw new Exception('İşlem bulunamadı');
    }

    $item = $item_stmt->fetch(PDO::FETCH_ASSOC);
    $service_record_id = $item['service_record_id'];

    // İşlemi sil
    $delete_query = "DELETE FROM service_items WHERE id = :id";
    $delete_stmt = $db->prepare($delete_query);
    $delete_stmt->bindParam(':id', $data->item_id);
    $delete_stmt->execute();

    // Servis kaydının toplam tutarını güncelle
    $update_query = "UPDATE service_records SET total_amount = (
                        SELECT COALESCE(SUM(total_price), 0) FROM service_items WHERE service_record_id = :service_record_id
                     ) WHERE id = :id";
    $update_stmt = $db->prepare($update_query);
    $update_stmt->bindParam(':service_record_id', $service_record_id);
    $update_stmt->bindParam(':id', $service_record_id);
    $update_stmt->execute();

    $db->commit();

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'İşlem silindi'
    ]);

} catch (Exception $e) {
    $db->rollBack();
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
