<?php
// Servise İşlem/Malzeme Ekleme (Teknisyen ve Admin)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Geçersiz token']);
    exit();
}

$data = json_decode(file_get_contents("php://input"));

if (empty($data->service_record_id) || empty($data->item_type) || empty($data->description) ||
    !isset($data->unit_price) || !isset($data->quantity)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Gerekli alanlar eksik'
    ]);
    exit();
}

try {
    $db->beginTransaction();

    // Servis kaydı kontrolü
    $service_query = "SELECT id FROM service_records WHERE id = :id LIMIT 1";
    $service_stmt = $db->prepare($service_query);
    $service_stmt->bindParam(':id', $data->service_record_id);
    $service_stmt->execute();

    if ($service_stmt->rowCount() == 0) {
        throw new Exception('Servis kaydı bulunamadı');
    }

    // Toplam fiyat hesapla
    $total_price = $data->quantity * $data->unit_price;

    // Servis item ekle
    $item_query = "INSERT INTO service_items (service_record_id, item_type, description, quantity, unit_price, total_price)
                  VALUES (:service_record_id, :item_type, :description, :quantity, :unit_price, :total_price)";

    $item_stmt = $db->prepare($item_query);
    $item_stmt->bindParam(':service_record_id', $data->service_record_id);
    $item_stmt->bindParam(':item_type', $data->item_type);
    $item_stmt->bindParam(':description', $data->description);
    $item_stmt->bindParam(':quantity', $data->quantity);
    $item_stmt->bindParam(':unit_price', $data->unit_price);
    $item_stmt->bindParam(':total_price', $total_price);
    $item_stmt->execute();

    // Servis kaydının toplam tutarını güncelle
    $update_query = "UPDATE service_records SET total_amount = (
                        SELECT SUM(total_price) FROM service_items WHERE service_record_id = :service_record_id
                     ) WHERE id = :id";
    $update_stmt = $db->prepare($update_query);
    $update_stmt->bindParam(':service_record_id', $data->service_record_id);
    $update_stmt->bindParam(':id', $data->service_record_id);
    $update_stmt->execute();

    $db->commit();

    http_response_code(201);
    echo json_encode([
        'success' => true,
        'message' => 'İşlem eklendi',
        'item_id' => $db->lastInsertId()
    ]);

} catch (Exception $e) {
    $db->rollBack();
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
