<?php
// Araç için tamamlanmamış servis kontrolü

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Geçersiz token']);
    exit();
}

if (empty($_GET['vehicle_id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Araç ID gerekli']);
    exit();
}

try {
    $vehicle_id = $_GET['vehicle_id'];

    // Araç için tamamlanmamış servis var mı kontrol et
    $query = "SELECT id, status, service_date, km_reading, description, total_amount
              FROM service_records
              WHERE vehicle_id = :vehicle_id
              AND status IN ('pending', 'in_progress')
              ORDER BY created_at DESC
              LIMIT 1";

    $stmt = $db->prepare($query);
    $stmt->bindParam(':vehicle_id', $vehicle_id);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $service = $stmt->fetch(PDO::FETCH_ASSOC);

        http_response_code(200);
        echo json_encode([
            'success' => true,
            'has_incomplete' => true,
            'service' => $service
        ]);
    } else {
        http_response_code(200);
        echo json_encode([
            'success' => true,
            'has_incomplete' => false,
            'service' => null
        ]);
    }

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
