<?php
// Ödeme Kaydı Oluşturma (Sadece Admin)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded || $decoded['role'] != 'admin') {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Yetkiniz yok']);
    exit();
}

$data = json_decode(file_get_contents("php://input"));

if (empty($data->service_record_id) || empty($data->customer_id) || !isset($data->amount) ||
    empty($data->payment_method)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Gerekli alanlar eksik'
    ]);
    exit();
}

try {
    $query = "INSERT INTO payments (service_record_id, customer_id, amount, payment_method, payment_date, notes, created_by)
             VALUES (:service_record_id, :customer_id, :amount, :payment_method, :payment_date, :notes, :created_by)";

    $stmt = $db->prepare($query);
    $stmt->bindParam(':service_record_id', $data->service_record_id);
    $stmt->bindParam(':customer_id', $data->customer_id);
    $stmt->bindParam(':amount', $data->amount);
    $stmt->bindParam(':payment_method', $data->payment_method);

    $payment_date = isset($data->payment_date) ? $data->payment_date : date('Y-m-d');
    $stmt->bindParam(':payment_date', $payment_date);

    $notes = isset($data->notes) ? $data->notes : null;
    $stmt->bindParam(':notes', $notes);

    $stmt->bindParam(':created_by', $decoded['user_id']);

    $stmt->execute();

    http_response_code(201);
    echo json_encode([
        'success' => true,
        'message' => 'Ödeme kaydedildi',
        'payment_id' => $db->lastInsertId()
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
