<?php
// Ödeme Ekleme (Admin ve Teknisyen)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Geçersiz token']);
    exit();
}

$data = json_decode(file_get_contents("php://input"));

if (empty($data->customer_id) || empty($data->amount) || empty($data->payment_method)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Gerekli alanlar eksik'
    ]);
    exit();
}

try {
    $db->beginTransaction();

    // Müşteri kontrolü
    $customer_query = "SELECT id FROM customers WHERE id = :id LIMIT 1";
    $customer_stmt = $db->prepare($customer_query);
    $customer_stmt->bindParam(':id', $data->customer_id);
    $customer_stmt->execute();

    if ($customer_stmt->rowCount() == 0) {
        throw new Exception('Müşteri bulunamadı');
    }

    // Servis kaydı kontrolü (opsiyonel)
    if (isset($data->service_record_id) && !empty($data->service_record_id)) {
        $service_query = "SELECT id FROM service_records WHERE id = :id LIMIT 1";
        $service_stmt = $db->prepare($service_query);
        $service_stmt->bindParam(':id', $data->service_record_id);
        $service_stmt->execute();

        if ($service_stmt->rowCount() == 0) {
            throw new Exception('Servis kaydı bulunamadı');
        }
    }

    // Ödeme ekle
    $payment_query = "INSERT INTO payments (service_record_id, customer_id, amount, payment_method, payment_date, notes, created_by)
                     VALUES (:service_record_id, :customer_id, :amount, :payment_method, :payment_date, :notes, :created_by)";

    $payment_stmt = $db->prepare($payment_query);

    $service_record_id = isset($data->service_record_id) ? $data->service_record_id : null;
    $payment_stmt->bindParam(':service_record_id', $service_record_id);
    $payment_stmt->bindParam(':customer_id', $data->customer_id);
    $payment_stmt->bindParam(':amount', $data->amount);
    $payment_stmt->bindParam(':payment_method', $data->payment_method);

    $payment_date = isset($data->payment_date) ? $data->payment_date : date('Y-m-d');
    $payment_stmt->bindParam(':payment_date', $payment_date);

    $notes = isset($data->notes) ? $data->notes : null;
    $payment_stmt->bindParam(':notes', $notes);

    $payment_stmt->bindParam(':created_by', $decoded['user_id']);

    $payment_stmt->execute();
    $payment_id = $db->lastInsertId();

    $db->commit();

    http_response_code(201);
    echo json_encode([
        'success' => true,
        'message' => 'Ödeme kaydedildi',
        'payment_id' => $payment_id
    ]);

} catch (Exception $e) {
    $db->rollBack();
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
