<?php
// Müşteri Listesi (Admin ve Teknisyen)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Geçersiz token']);
    exit();
}

try {
    // Arama parametresi
    $search = isset($_GET['search']) ? $_GET['search'] : '';

    $query = "SELECT
                c.id,
                c.name,
                c.phone,
                c.email,
                c.address,
                (SELECT COUNT(DISTINCT v.id) FROM vehicles v WHERE v.customer_id = c.id) as vehicle_count,
                (SELECT COUNT(DISTINCT sr.id) FROM service_records sr JOIN vehicles v ON v.id = sr.vehicle_id WHERE v.customer_id = c.id) as service_count,
                (SELECT COALESCE(SUM(sr.total_amount), 0) FROM service_records sr JOIN vehicles v ON v.id = sr.vehicle_id WHERE v.customer_id = c.id) as total_debt,
                (SELECT COALESCE(SUM(p.amount), 0) FROM payments p WHERE p.customer_id = c.id) as total_paid,
                ((SELECT COALESCE(SUM(sr.total_amount), 0) FROM service_records sr JOIN vehicles v ON v.id = sr.vehicle_id WHERE v.customer_id = c.id) -
                 (SELECT COALESCE(SUM(p.amount), 0) FROM payments p WHERE p.customer_id = c.id)) as balance
              FROM customers c";

    if (!empty($search)) {
        $query .= " WHERE c.name LIKE :search OR c.phone LIKE :search";
    }

    $query .= " ORDER BY c.name ASC";

    $stmt = $db->prepare($query);

    if (!empty($search)) {
        $search_param = "%{$search}%";
        $stmt->bindParam(':search', $search_param);
    }

    $stmt->execute();
    $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'customers' => $customers
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
