<?php
// Kullanıcı Girişi (Teknisyen ve Admin)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->username) && !empty($data->password)) {

    $query = "SELECT id, username, password, full_name, role, is_active FROM users WHERE username = :username LIMIT 1";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':username', $data->username);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch();

        if ($user['is_active'] != 1) {
            http_response_code(403);
            echo json_encode([
                'success' => false,
                'message' => 'Hesabınız pasif durumda'
            ]);
            exit();
        }

        if (password_verify($data->password, $user['password'])) {

            $payload = [
                'iss' => APP_URL,
                'iat' => time(),
                'user_id' => $user['id'],
                'username' => $user['username'],
                'role' => $user['role']
            ];

            // JWT_EXPIRATION 0 ise süresiz token üret (exp claim'i ekleme)
            if (defined('JWT_EXPIRATION') && (int)JWT_EXPIRATION > 0) {
                $payload['exp'] = time() + (int)JWT_EXPIRATION;
            }

            $token = JWT::encode($payload);

            http_response_code(200);
            echo json_encode([
                'success' => true,
                'message' => 'Giriş başarılı',
                'token' => $token,
                'user' => [
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'full_name' => $user['full_name'],
                    'role' => $user['role']
                ]
            ]);
        } else {
            http_response_code(401);
            echo json_encode([
                'success' => false,
                'message' => 'Kullanıcı adı veya şifre hatalı'
            ]);
        }
    } else {
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'message' => 'Kullanıcı adı veya şifre hatalı'
        ]);
    }
} else {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Kullanıcı adı ve şifre gerekli'
    ]);
}
