<?php
// Tüm Servisleri Listeleme (Sadece Admin)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded || $decoded['role'] != 'admin') {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Yetkiniz yok']);
    exit();
}

$query = "SELECT sr.*, v.plate, v.brand, v.model, c.name as customer_name, c.phone,
          u.full_name as technician_name
          FROM service_records sr
          LEFT JOIN vehicles v ON v.id = sr.vehicle_id
          LEFT JOIN customers c ON c.id = v.customer_id
          LEFT JOIN users u ON u.id = sr.technician_id
          ORDER BY sr.service_date DESC, sr.created_at DESC";

$stmt = $db->prepare($query);
$stmt->execute();

$services = $stmt->fetchAll();

http_response_code(200);
echo json_encode([
    'success' => true,
    'data' => $services
]);
