<?php
// Müşteri Borç/Alacak Listesi (Sadece Admin)

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Database.php';
require_once __DIR__ . '/../core/JWT.php';

$database = new Database();
$db = $database->getConnection();

// Token kontrolü
$token = JWT::getBearerToken();
if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token bulunamadı']);
    exit();
}

$decoded = JWT::decode($token);
if (!$decoded || $decoded['role'] != 'admin') {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Yetkiniz yok']);
    exit();
}

// Borçlu müşteriler (balance > 0)
$only_debtors = isset($_GET['only_debtors']) ? $_GET['only_debtors'] : '0';

$query = "SELECT
            c.id AS customer_id,
            c.name AS customer_name,
            c.phone,
            COALESCE(d.total_debt, 0) AS total_debt,
            COALESCE(p.total_paid, 0) AS total_paid,
            COALESCE(d.total_debt, 0) - COALESCE(p.total_paid, 0) AS balance
          FROM customers c
          LEFT JOIN (
            SELECT v.customer_id, SUM(sr.total_amount) AS total_debt
            FROM vehicles v
            JOIN service_records sr ON sr.vehicle_id = v.id
            GROUP BY v.customer_id
          ) d ON d.customer_id = c.id
          LEFT JOIN (
            SELECT customer_id, SUM(amount) AS total_paid
            FROM payments
            GROUP BY customer_id
          ) p ON p.customer_id = c.id";

if ($only_debtors == '1') {
    $query .= " WHERE (COALESCE(d.total_debt, 0) - COALESCE(p.total_paid, 0)) > 0";
}

$query .= " ORDER BY balance DESC";

$stmt = $db->prepare($query);
$stmt->execute();

$balances = $stmt->fetchAll();

http_response_code(200);
echo json_encode([
    'success' => true,
    'data' => $balances
]);
